extern float4	g_Colour :		register(c0);
extern float4	g_Dimensions :	register(c1);
extern float	g_ScreenSpace :	register(c2);


struct VS_OUTPUT
{
	float4	m_Position :	POSITION;
	float4	m_Colour :		COLOR0;
	float2	m_TexCoord :	TEXCOORD0;
};



struct VS_INPUT
{
	float4	m_Position :	POSITION;
	float2	m_TexCoord :	TEXCOORD0;
};



VS_OUTPUT MainVS(VS_INPUT input)
{

	VS_OUTPUT output	=	(VS_OUTPUT) 0;
	
	float4	position	=	input.m_Position;
	position.xy			*=	g_Dimensions.zw;
	position.xy			+=	2.0f * (g_Dimensions.xy - 0.5f);
	
	output.m_Position	=	position;
	output.m_Colour		=	g_Colour;
	output.m_TexCoord	=	(g_ScreenSpace > 0.0f) ? float2(position.x * 0.5f, -position.y * 0.5f) + 0.5f : input.m_TexCoord;

	return output;

}